#!/bin/sh

WORK_DIR=/opt
MACHINE=Adventurer3-Sweden
PID=00E3

for i in 1 2 3 4;
do
  if [ ! -e /dev/sda$i ]; then
     echo "sda$i not exist"
	 if [ ! -e /dev/sda ];then
     	continue
	 else
	 	echo "find /dev/sda. start mount."
  		mount -t vfat -o rw /dev/sda /mnt
	 fi
  else
  	mount -t vfat -o rw /dev/sda$i /mnt
  fi

  if [ $? -ne 0 ]; then
        echo "mount /dev/sda or /dev/sda$i to /mnt failed"
        continue
  else
  		ls -1t /mnt/Adventurer3*.tgz
		if [ $? -eq 0 ];then
			UPDATEFILE=`ls -1t /mnt/Adventurer3*.tgz | head -n 1`
			if [ -f $UPDATEFILE ];then
				echo "find update file: ${UPDATEFILE}"
				rm -rf /data/update
				cp -a ${UPDATEFILE} /data/
				if [ $? -ne 0 ];then
					rm -rf /data/Adventurer3*.tgz
					sync
					umount /mnt
					break
				fi
				sync
				mkdir -p /data/update
				sync
				SRCFILE="/data/`basename ${UPDATEFILE}`"
				if [ -f ${SRCFILE} ];then
					tar -xzvf ${SRCFILE} -C /data/update/
					sync
					rm -rf ${SRCFILE}
					/data/update/flashforge_init.sh ${MACHINE} ${PID}
					if [ $? -eq 0 ];then
						umount /mnt
						rm -rf /data/update
						sleep 100000
					fi
					umount /mnt
					rm -rf /data/update
					break
				fi
			fi
		fi

        if [ -f /mnt/flashforge_init.sh ]; then
             echo "found /mnt/flashforge_init.sh"
             chmod a+x /mnt/flashforge_init.sh
             /mnt/flashforge_init.sh ${MACHINE} ${PID}
			 if [ $? -eq 0 ];then
				umount /mnt
				sleep 100000
			 fi
             umount /mnt
             break
        fi
        umount /mnt
  fi
done

if [ -d /data/update ];then
	rm -rf /data/update
fi

#echo "export libiconv"
#export LD_LIBRARY_PATH=$WORK_DIR/libiconv-1.14-none/lib:$LD_LIBRARY_PATH

#MJPG_STREAM                                                                              
echo "mjpg-streamer"                                                                        
export MJPGDIR=$WORK_DIR/mjpg-streamer                                                      
export PATH=$MJPGDIR/bin:$PATH                                                              
export LD_LIBRARY_PATH=$MJPGDIR/lib:$MJPGDIR/jpeg/lib:$LD_LIBRARY_PATH

# OPENSSL
echo "export openssl"
export PATH=$WORK_DIR/openssl-1.0.2d/bin:$PATH
export OPENSSL_DIR=$WORK_DIR/openssl-1.0.2d
export LD_LIBRARY_PATH=$OPENSSL_DIR/lib:$LD_LIBRARY_PATH

#CLOUD
echo "export cloud"
export CLOUDDIR=$WORK_DIR/cloud
export PATH=$CLOUDDIR/curl-7.55.1/bin:$PATH
export LD_LIBRARY_PATH=$CLOUDDIR/curl-7.55.1/lib:$CLOUDDIR/mips_jsoncpp/lib:$CLOUDDIR/boost/lib:$CLOUDDIR/socketio/lib:$LD_LIBRARY_PATH

# TSLIB
echo "export tslib"
export TSLIBDIR=$WORK_DIR/tslib
export TSLIB_TSEVENTTYPE=INPUT
export TSLIB_CONSOLEDEVICE=none
export TSLIB_FBDEVICE=/dev/fb0
export TSLIB_TSDEVICE=/dev/input/event0
export TSLIB_CALIBFILE=$TSLIBDIR/etc/pointercal
export TSLIB_CONFFILE=$TSLIBDIR/etc/ts.conf
export TSLIB_PLUGINDIR=$TSLIBDIR/lib/ts
export QWS_MOUSE_PROTO="TSLIB:/dev/input/event0"
export PATH=$TSLIBDIR/bin:$PATH
export LD_LIBRARY_PATH=$TSLIBDIR/lib:$LD_LIBRARY_PATH

# QT
echo "export qt"
export QTDIR=$WORK_DIR/qt4.8.6-mipsel-openwrt
export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
export QT_QPA_PLATFORM_PLUGIN_PATH=$QTDIR/plugins
export QT_QPA_PLATFORM=linuxfb:tty=/dev/fb0:size=240x320:mmsize=25x15:offset=0
export QWS_DISPLAY=transformed:rot180:LinuxFB:mmWidth96:mmHeight48:0
export QT_QWS_FONTDIR=$QTDIR/lib/fonts
#export LD_PRELOAD=$WORK_DIR/libiconv-1.14-none/lib/preloadable_libiconv.so:$TSLIBDIR/lib/libts.so
export LD_PRELOAD=$TSLIBDIR/lib/libts.so
export QT_QPA_GENERIC_PLUGINS=tslib

echo 19 > /sys/class/gpio/export
echo out > /sys/class/gpio/gpio19/direction
echo 1 > /sys/class/gpio/gpio19/value
echo 19 > /sys/class/gpio/unexport

art_check=`hexdump -n 2 /lib/firmware/mt7628.eeprom | head -n 1 | awk '{print $2}'`

if [ "${art_check}" != "7628" ];then
    echo "/lib/firmware/mt7628.eeprom -- error"
    rm -rf /lib/firmware/mt7628.eeprom
    sync
    dd if=/dev/mtd2 of=/lib/firmware/mt7628.eeprom bs=1 count=512
    sync
fi

rm -rf /data/picture/*.jpg
#/opt/finder_rush/exe/finder-rush-mips -1 -D -qws
/opt/finder_rush/exe/finder-rush-mips -1 -qws > /dev/null &
