#!/bin/sh

VERSION=1.2.2
M3VERSION=1.6
BUILDTIME=`date "+%Y%m%d"`
MACHINE=Adventurer3-Sweden
PID=00E3
FILENAME="${MACHINE}-${VERSION}-${M3VERSION}-${BUILDTIME}.tgz"
VERFILE=version

sed -i "/^MACHINE=Adventurer3*/c MACHINE=${MACHINE}" ./auto_run.sh
sed -i "/^MACHINE=Adventurer3*/c MACHINE=${MACHINE}" ./flashforge_init.sh

sed -i "/^PID=*/c PID=${PID}" ./auto_run.sh
sed -i "/^PID=*/c PID=${PID}" ./flashforge_init.sh

sync

if [ ! -d ../image ];then
	mkdir -p ../image
fi

sed -i '36,44 s/^uci/#uci/g' ./flashforge_init.sh
sync

tar -czvf ${FILENAME} ./*

echo "version=${VERSION}" >> ${VERFILE}
echo "buildtime=${BUILDTIME}" >> ${VERFILE}
echo "file=${FILENAME}" >> ${VERFILE}
echo "md5=`md5sum ${FILENAME} | cut -d ' ' -f1`" >> ${VERFILE}

mv ${FILENAME} ../image
mv ${VERFILE}  ../image

sync

sed -i '36,44 s/^#uci/uci/g' ./flashforge_init.sh
touch screwflag
sync

FACTORY_FILENAME="${MACHINE}-${VERSION}-${M3VERSION}-${BUILDTIME}-Factory.tgz"
tar -czvf ${FACTORY_FILENAME} ./*
rm -rf ./screwflag
mv ${FACTORY_FILENAME} ../image
sync

