#!/bin/sh

WORKDIR=`dirname $0`

HK_FIRMWARE_M3=Adventurer3-ISP-HK-1.6.0-20210517.hex
STM_FIRMWARE_M3=Adventurer3-ISP-STM-1.6.0-20210517.hex
NATION_FIRMWARE_M3=Adventurer3-IAP-1.6.0-20210517.hex
STM_DIR=/opt/stm32

M3_VERSION=${FIRMWARE_M3#*Adventurer3-}
M3_VERSION=${M3_VERSION%.*}

MACHINE=Adventurer3-Sweden
PID=00E3
BACKUP_DIR=/opt/backup
MACHINE_ARCH=mips

#检测机器的架构,错误马上退出
CHECH_ARCH=`uname -m`
if [ "${MACHINE_ARCH}" != "${CHECH_ARCH}" ];then
    echo "Machine architecture error."
	echo ${CHECH_ARCH}
	exit 1
fi

#screwflag为丝杆标志文件,存在说明在工厂里,可任意升级
if [ ! -f $WORKDIR/screwflag ]; then 
	#第1、2个参数为空,说明没有传递参数,为老版本固件,可升级
	if [ "$1" != "" ] && [ "$2" != "" ];then
		if [ "$1" != "${MACHINE}" ] || [ "$2" != "${PID}" ];then
			echo "Firmware does not match machine type."
			exit 1
		fi
	fi
fi

##########################################

#uci set wireless.ap.ssid='Adventurer 3'
#uci commit
sync

##########################################

cat $WORKDIR/start.img > /dev/fb0

# cp -vf /tmp/test /data/
# $1  源文件路径名 /tmp/test
# $2  目标路径名   /data/

cp_file()
{
	SRCFILE="$1"
	DSTFILE="$2`basename $1`"
	if [ ! -f $DSTFILE ];then
		cp -vf ${SRCFILE} $2
		chmod a+x $DSTFILE
	fi
	SRCFILEMD5=`md5sum $SRCFILE | cut -d ' ' -f 1`
	DSTFILEMD5=`md5sum $DSTFILE | cut -d ' ' -f 1`
	while [ "$SRCFILEMD5" != "$DSTFILEMD5" ];do
		rm -rf ${DSTFILE}
		cp -vf ${SRCFILE} $2
		chmod a+x $DSTFILE
		sync
		DSTFILEMD5=`md5sum $DSTFILE | cut -d ' ' -f 1`
	done
	#echo ${SRCFILEMD5}
	#echo ${DSTFILEMD5}
}

if [ ! -d $STM_DIR ];then
	echo "create /opt/stm32"
	mkdir -p $STM_DIR
	sync
	echo "copy command and hex to /opt/stm32"
	cp_file $WORKDIR/$NATION_FIRMWARE_M3 ${STM_DIR}/
	cp_file $WORKDIR/$STM_FIRMWARE_M3 ${STM_DIR}/
	cp_file $WORKDIR/$HK_FIRMWARE_M3 ${STM_DIR}/
	cp_file $WORKDIR/IAPCommand ${STM_DIR}/
	cp_file $WORKDIR/ISPCommand ${STM_DIR}/
	sync
else
	echo "rm /opt/stm32"
	rm -rf $STM_DIR
	echo "create /opt/stm32"
	mkdir -p $STM_DIR
	sync
	echo "copy command and hex to /opt/stm32"
	cp_file $WORKDIR/$NATION_FIRMWARE_M3 ${STM_DIR}/
	cp_file $WORKDIR/$STM_FIRMWARE_M3 ${STM_DIR}/
	cp_file $WORKDIR/$HK_FIRMWARE_M3 ${STM_DIR}/
	cp_file $WORKDIR/IAPCommand ${STM_DIR}/
	cp_file $WORKDIR/ISPCommand ${STM_DIR}/
	sync
fi

if [ -f $WORKDIR/IAPCommand -a -f $WORKDIR/ISPCommand ];then
	chmod a+x $WORKDIR/IAPCommand
	chmod a+x $WORKDIR/ISPCommand
	if [ -f $WORKDIR/$NATION_FIRMWARE_M3 -a -f $WORKDIR/$STM_FIRMWARE_M3 -a -f $WORKDIR/$HK_FIRMWARE_M3 ];then
		echo "burn M3 firmware..."
		$WORKDIR/IAPCommand $WORKDIR/$NATION_FIRMWARE_M3 $WORKDIR $STM_FIRMWARE_M3 $HK_FIRMWARE_M3
	fi
fi

if [ ! -h /etc/rc.d/S60dnsmasq ];then
	ln -s /etc/init.d/dnsmasq /etc/rc.d/S60dnsmasq
fi

if [ -f $WORKDIR/command.sh ];then
	if [ ! -d /data/picture ];then
		mkdir -p /data/picture
	fi
	cp_file $WORKDIR/command.sh /data/picture/
fi

if [ -f $WORKDIR/screwflag ]; then
	echo "update screwflag"
	cp_file $WORKDIR/screwflag /opt/
fi

if [ -f $WORKDIR/code2000.ttf ];then
	echo "update code2000.ttf"
	cp_file $WORKDIR/code2000.ttf /opt/qt4.8.6-mipsel-openwrt/lib/fonts/
fi

if [ -f $WORKDIR/auto_run.sh ]; then
	echo "update auto_run.sh"
	cp_file $WORKDIR/auto_run.sh /opt/
fi

if [ -f $WORKDIR/finder-rush-mips ]; then
	if [ -d /opt/finder_rush/exe ]; then
		echo "clean /opt/finder_rush/exe"
		rm -rf /opt/finder_rush/exe
	fi

	echo "create /opt/finder_rush"
	mkdir -p /opt/finder_rush/exe

	echo "update /opt/finder_rush/exe/finder-rush-mips"
	cp_file $WORKDIR/finder-rush-mips  /opt/finder_rush/exe/
fi


if [ ! -f /opt/art.img ]; then
	echo "update art file"
	dd if=/dev/mtd2 of=/opt/art.img
	sync
fi

if [ -f $WORKDIR/uboot.bin ];then
	echo "update uboot"
	dd if=$WORKDIR/uboot.bin of=/dev/mtdblock0
	sync
fi

if [ ! -d $BACKUP_DIR ];then
	mkdir -p $BACKUP_DIR
	sync
fi

if [ -f $WORKDIR/cloud.tar ];then
	if [ ! -f ${BACKUP_DIR}/cloud.tar ];then
		rm -rf /opt/cloud
		tar -xvf $WORKDIR/cloud.tar -C /opt/
		cp_file $WORKDIR/cloud.tar ${BACKUP_DIR}/
		sync
	else
		SRC_TAR_FILE_MD5=`md5sum ${WORKDIR}/cloud.tar | cut -d ' ' -f 1`
		DST_TAR_FILE_MD5=`md5sum ${BACKUP_DIR}/cloud.tar | cut -d ' ' -f 1`
		echo "source tar file md5: ${SRC_TAR_FILE_MD5}"
		echo "destination tar file md5: ${DST_TAR_FILE_MD5}"
		if [ "${SRC_TAR_FILE_MD5}" != "${DST_TAR_FILE_MD5}" ];then
			echo "update cloud.tar"
			rm -rf /opt/cloud
			tar -xvf $WORKDIR/cloud.tar -C /opt/
			cp_file $WORKDIR/cloud.tar ${BACKUP_DIR}/
			sync
		fi
	fi
fi

#if(源文件存在){
#	if(目标文件不存在){
#		升级源文件
#		复制源文件到目标文件夹下(备份)
#	}else{//目标文件存在
#		对比源文件和目标文件；
#		if(不相同){
#			删除目标文件
#			升级源文件
#			复制源文件到目标文件夹下(备份)
#		}
#	}
#}

UIMAGW_FILE_PREFIX=uImage-adventurer3
ls -1t ${WORKDIR}/${UIMAGW_FILE_PREFIX}*
if [ $? -eq 0 ]; then
	SRC_UIMAGE=`ls -1t ${WORKDIR}/${UIMAGW_FILE_PREFIX}* | head -n 1`
	echo "source uImage file: ${SRC_UIMAGE}"
	if [ -f $SRC_UIMAGE ]; then
		ls -1t ${BACKUP_DIR}/${UIMAGW_FILE_PREFIX}*
		if [ $? -ne 0 ];then
			echo "update uImage"
			dd if=$SRC_UIMAGE of=/dev/mmcblk0 seek=10 bs=512
			sync
			cp_file ${SRC_UIMAGE} ${BACKUP_DIR}/
			sync
		else
			DST_UIMAGE=`ls -1t ${BACKUP_DIR}/${UIMAGW_FILE_PREFIX}* | head -n 1`
			if [ -f ${DST_UIMAGE} ];then
				echo "destination uImage file: ${DST_UIMAGE}"
				SRC_UIMAGE_MD5=`md5sum ${SRC_UIMAGE} | cut -d ' ' -f 1`
				DST_UIMAGE_MD5=`md5sum ${DST_UIMAGE} | cut -d ' ' -f 1`
				echo "source uImage md5: ${SRC_UIMAGE_MD5}"
				echo "destination uImage md5: ${DST_UIMAGE_MD5}"
				if [ "${SRC_UIMAGE_MD5}" != "${DST_UIMAGE_MD5}" ];then
					echo "update uImage"
					dd if=$SRC_UIMAGE of=/dev/mmcblk0 seek=10 bs=512
					sync
					rm -rf ${DST_UIMAGE}
					sync
					cp_file ${SRC_UIMAGE} ${BACKUP_DIR}/
					sync
				fi
			fi
		fi
	fi
fi

sync
cat $WORKDIR/end.img > /dev/fb0

$WORKDIR/play

exit 0
